class MonsterHUD extends ChallengeHUD;

#exec TEXTURE IMPORT NAME=HUD_Statuselement FILE=Textures\HUD_Statuselement.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Healthbar FILE=Textures\HUD_Healthbar.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Hearticon FILE=Textures\HUD_Hearticon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Ammoicon FILE=Textures\HUD_Ammoicon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Armoricon FILE=Textures\HUD_Armoricon.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Bootselement FILE=Textures\HUD_Bootselement.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Scubagear FILE=Textures\HUD_Scubagear.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Invis FILE=Textures\HUD_Invis.bmp Group=HUD MIPS=ON
//#exec TEXTURE IMPORT NAME=HUD_UDamage FILE=Textures\HUD_UDamage.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=HUD_Marble FILE=Textures\HUD_Marble.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Whiteness FILE=Textures\Whiteness.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Skill_MaxHealth FILE=Textures\Skill_MaxHealth.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Skill_Ilumination FILE=Textures\Skill_Ilumination.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Skill_HealthRegain FILE=Textures\Skill_HealthRegain.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Skill_AmmoRegain FILE=Textures\Skill_AmmoRegain.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Skill_AddToDamage FILE=Textures\Skill_AddToDamage.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Skill_ReduceDamage FILE=Textures\Skill_ReduceDamage.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Gun_Lawgiver FILE=Textures\Gun_Lawgiver.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Gun_Railgun FILE=Textures\Gun_Railgun.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Gun_Headremover FILE=Textures\Gun_Headremover.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Gun_Instigator FILE=Textures\Gun_Instigator.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Gun_Shredder FILE=Textures\Gun_Shredder.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Gun_Blaster FILE=Textures\Gun_Blaster.bmp Group=HUD MIPS=ON
//Radar textures:
#exec Texture Import File=Textures\Radar.bmp Name=Radar Group=HUD
#exec Texture Import File=Textures\RadarBorder.bmp Name=RadarBorder Group=HUD
#exec Texture Import File=Textures\Dots.bmp Name=Dots Group=HUD
#exec Texture Import File=Textures\OpenGL.bmp Name=OpenGL Group=HUD

#exec OBJ LOAD FILE=..\Textures\LadrStatic.utx PACKAGE=Botpack.LadrStatic

var() int SizeY,Count;
var string CurrentMessage;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var PlayerReplicationInfo IdentifyTarget;
var Pawn PawnOwner;	// pawn currently managing this HUD (may be the viewtarget of the owner rather than the owner)
var FontInfo MyFonts;

// Localized Messages
var HUDLocalizedMessage ShortMessageQueue[6];
var HUDLocalizedMessage LocalMessages[10];

var texture FaceTexture;
var float FaceTime;
var color FaceTeam;
 
var() localized string VersionMessage, PlayerCountString;
var localized string MapTitleString, AuthorString;
var localized string MapTitleString2, AuthorString2;

var localized string RankString;
var localized string SpreadString;

var int PlayerCount;
var bool bTiedScore;

var string ReceivedMessage;
var string ReceivedName;
var ZoneInfo ReceivedZone;
var float ReceivedTime;
var texture TutIconTex;
var int TutIconX, TutIconY;
var float TutIconBlink;

var globalconfig int CrosshairCount;
var globalconfig string CrossHairs[20];
var texture CrossHairTextures[20];

var texture GrayWeapons[11];
var texture FP1[3], FP2[3], FP3[3];
var int LastReportedTime;
var bool bStartUpMessage, bForceScores;
var bool bTimeValid;
var bool bLowRes;
var bool bResChanged;
var int OldClipX;

// configuration options
var bool bAlwaysHideFrags, bHideCenterMessages;
var globalconfig bool bHideAllWeapons, bHideStatus, bHideAmmo, bHideTeamInfo, bHideFrags, bHideHUD, bHideNoviceMessages, bHideFaces;
var globalconfig bool bUseTeamColor;
var globalconfig byte Opacity;	// should be between 1 and 16
var globalconfig float HUDScale, StatusScale, WeaponScale;
var globalconfig color FavoriteHUDColor, CrosshairColor;
var float Scale;
var byte Style;
var color BaseColor, WhiteColor, RedColor, GreenColor, CyanColor, UnitColor, BlueColor, BlackColor,
		 GoldColor, HUDColor, SolidHUDColor, PurpleColor, TurqColor, GrayColor, FaceColor, FrameColor,
		InfoColor;

// Identify Strings
var localized string IdentifyName, IdentifyHealth, IdentifyCallsign;
var localized string LiveFeed;

// scoring 
var float ScoreTime;
var int rank, lead;

// showing damage
var vector HitPos[4];
var float HitTime[4];
var float HitDamage[4];

var float PickupTime;

var float WeaponNameFade;
var float MessageFadeTime;
var int MessageFadeCount;
var bool bDrawMessageArea;
var bool bDrawFaceArea;
var float FaceAreaOffset, MinFaceAreaOffset;
var class<CriticalEventPlus> TimeMessageClass;

// Server info.
var ServerInfo ServerInfo;
var bool bShowInfo;

var class<ServerInfo> ServerInfoClass;

var globalconfig string FontInfoClass;

var bool bTimeDown;

//custom vars
var int RedPulse, IntroColor, Counter2, DamageCharge;
var bool bPulseUp, bIntroRendered, bImpactSound, bScaleSet, bDrawText, bPlayBoom, bFadeLogo, bWhiteColorDone, bFrameUp, bBuy, bNext, bNotEneoughSouls, bAtMax;
var bool bNotEneoughGold, bAlreadyHasGun, bDrawInfoText, bInfoDown, bDamage;
var float LogoDrawScale, InfoScale;
var string SplashText, Skill, Guns;
var byte ErrorColor;

//radar vars:
var float LastDrawRadar, RadarScale, RadarPosX, RadarPosY, RadarPulse;
var color RadarColor;
//Team Beacon vars:
var float			mMinScale;
var float			mMaxScale;

simulated function RenderInfo(Canvas Canvas)
{
local float XL,YL;

	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Normal;

	Canvas.SetPos(Canvas.ClipX * 0.5 - 400 * InfoScale, Canvas.ClipY * 0.5 - 300 * InfoScale);

	Canvas.DrawTile(Texture'BlackColor', 800 * InfoScale, 600 * InfoScale, 0, 0, 800 * InfoScale, 600 * InfoScale);

	if ( InfoScale < 1 && !bInfoDown )
		{
		InfoScale += 0.02;
		}
	else if ( !bInfoDown )
		{
		InfoScale = 1;
		bDrawInfoText = True;
		if ( InfoColor.R < 253 && !bInfoDown)
			{
			InfoColor.R += 3;
			InfoColor.G += 3;
			InfoColor.B += 3;
			}
		else if ( !bInfoDown )
			{
			InfoColor.R = 255;
			InfoColor.G = 255;
			InfoColor.B = 255;
			}
		}

	if ( bDrawInfoText )
		{
		Canvas.bCenter = True;
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 270);
		Canvas.DrawColor = InfoColor;
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Headline);

		Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*6);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line00);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*7);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line01);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*8);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line02);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*9);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line03);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*10);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line04);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*11);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line05);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*12);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line06);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*13);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line07);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*14);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line08);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*15);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line09);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*16);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line10);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*17);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line11);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*18);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line12);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*19);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line13);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*20);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line14);
		Canvas.SetPos(0, Canvas.ClipY * 0.5 - 300 + YL*21);
		Canvas.DrawText(Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).Line15);
		}
	if ( bInfoDown )
		{
		if ( InfoColor.R > 3 )
			{
			InfoColor.R -= 4;
			InfoColor.G -= 4;
			InfoColor.B -= 4;
			}
		else
			{
			if ( InfoScale > 0 )
				{
				bDrawInfoText = False;
				InfoScale -= 0.02;
				}
			else
				{
				Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bInfoOpen = False;
				bInfoDown = False;
				}
			}
		}
}

simulated function RenderIntro(Canvas Canvas)
{
local float XL,YL;
local GameReplicationInfo GRI;

	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.bCenter = true;
	Canvas.DrawColor.R = IntroColor;
	Canvas.DrawColor.G = IntroColor;
	Canvas.DrawColor.B = IntroColor;

	Canvas.SetPos(0, 0);
	Canvas.StrLen("TEST", XL, YL);
	Canvas.DrawText(GRI.ServerName);

	Canvas.SetPos(0, YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0, 2*YL);
	Canvas.DrawText("Battleground:"@Level.Title$", Author:"@Level.Author, true);

	Canvas.bCenter = false;

	if ( !bScaleSet )
		{
		bScaleSet = True;
		LogoDrawScale = 60;
		IntroColor = 255;
		}

	if ( LogoDrawScale > 1 )
		{
		LogodrawScale -= 0.3;
		}
	else
		{
		LogodrawScale = 1;
		if ( !bImpactSound )
			{
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.General.SpecialExpl',,2.0);
			bImpactSound = True;
			bDrawText = True;
			}
		}

	Canvas.DrawColor.R = IntroColor;
	Canvas.DrawColor.G = IntroColor;
	Canvas.DrawColor.B = IntroColor;
	
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 0.5 * (512 * LogoDrawScale), (Canvas.ClipY * 0.5) - 0.5 * (256 * LogoDrawScale) );
	Canvas.DrawTile(Texture'OpenGL', 512 * LogoDrawScale, 256 * LogoDrawScale, 0, 0, 512, 256);

	if ( bDrawText)
		{
		Canvas.bCenter = False;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
		Canvas.StrLen("The way it's ment to be rendered!", XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5 - XL * 0.5,Canvas.ClipY * 0.5 + 128);

		Counter2++;

		if ( Counter2 == 220 )
			{
			SplashText = "The way it's meant to be rendered!";
			bPlayBoom = False;
			}
		else if ( Counter2 == 200 )
			{
			SplashText = "The way it's meant to be";
			bPlayBoom = False;
			}
		else if ( Counter2 == 180 )
			{
			SplashText = "The way it's meant to";
			bPlayBoom = False;
			}
		else if ( Counter2 == 160 )
			{
			SplashText = "The way it's meant";
			bPlayBoom = False;
			}
		else if ( Counter2 == 140 )
			{
			SplashText = "The way it's";
			bPlayBoom = False;
			}
		else if ( Counter2 == 120 )
			{
			SplashText = "The way";
			bPlayBoom = False;
			}
		else if ( Counter2 == 100 )
			{
			SplashText = "The";
			bPlayBoom = False;
			}
		if ( Counter2 == 280 )
			{
			bFadeLogo = True;
			}
		if ( bFadeLogo )
			{
			IntroColor -= 4;
			if ( IntroColor <= 0 )
				{
				bIntroRendered = True;
				}
			}

		Canvas.DrawText(SplashText);

		if ( !bPlayBoom )
			{
			PlayerPawn(Owner).PlaySound (Sound'BotPack.ASMD.ImpactFire',,2.0);
			bPlayBoom = True;
			}
		}
	
}

simulated function DrawFrame(Canvas Canvas,float Xpos, float Ypos)
{
	Canvas.DrawColor = FrameColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Xpos, Ypos);
	Canvas.DrawTile(Texture'Whiteness', 328, 4, 0, 0, 324, 2);
	Canvas.SetPos(Xpos, Ypos + 132);
	Canvas.DrawTile(Texture'Whiteness', 328, 4, 0, 0, 324, 2);
	Canvas.SetPos(Xpos, Ypos + 4);
	Canvas.DrawTile(Texture'Whiteness', 4, 128, 0, 0, 4, 128);
	Canvas.SetPos(Xpos + 324, Ypos + 4);
	Canvas.DrawTile(Texture'Whiteness', 4, 128, 0, 0, 4, 128);

	if ( bFrameUp )
		{
		FrameColor.R += 5;
		FrameColor.G += 5;
		if ( FrameColor.R >= 251 )
			{
			bFrameUp = False;
			}
		}
	else
		{
		FrameColor.R -= 5;
		FrameColor.G -= 5;
		if ( FrameColor.R <= 4 )
			{
			bFrameUp = True;
			}
		}

}

simulated function RenderWeaponShop(Canvas Canvas)
{
local Info_PRI PRI;
local float XL,YL, Xpos, Ypos;
local float FrameX, FrameY;

	PRI = Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(0, 0);
	Canvas.DrawTile(Texture'HUD_Marble', Canvas.ClipX, Canvas.ClipY, 0, 0, Canvas.ClipX, Canvas.ClipY);

	//Draw Headline:
	Canvas.DrawColor = GreenColor;
	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen(PRI.ShopName, XL, YL);
	Canvas.SetPos(0, 0);
	Canvas.DrawText(PRI.ShopName);
	Canvas.SetPos(0, YL);
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = GoldColor;
	Canvas.DrawText("You have"@PRI.GoldAmount$" goldpieces and"@PRI.Souls$" souls.");
	Ypos = YL * 3; //used to set Y location for the skill tree
	FrameY = YL * 3 - 4; //used to draw frame

	//Draw how to use shop	
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL * 2);
	Canvas.DrawText("To use the shop open console and type:");
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Next = Navigate, Buy = Purchase & Leave = Leave shop.");

	Canvas.bCenter = False;

	//Lawgiver:
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 380, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 378, Ypos + 32);
	Canvas.DrawTile(Texture'Gun_Lawgiver', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Lawgiver", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Lawgiver");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Costs: 500 gold pieces", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Costs: 500 gold pieces");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("x5 Damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("x5 Damage");
	Canvas.StrLen("+ Explosive Impact", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("+ Explosive Impact");

	//Railgun:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 60, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 62, Ypos + 32);
	Canvas.DrawTile(Texture'Gun_Railgun', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Railgun", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Railgun");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Costs: 600 gold pieces", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Costs: 600 gold pieces");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("x3 Damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("x3 Damage");
	Canvas.StrLen("+ Explosive Impact", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("+ Explosive Impact");

	//Headremover:
	Ypos += 160;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 380, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 378, Ypos + 32);
	Canvas.DrawTile(Texture'Gun_Headremover', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Headremover", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Headremover");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Costs: 1000 goldpieces", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Costs: 1000 goldpieces");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("x2 Damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("x2 Damage");
	Canvas.StrLen("Very fast firerate", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Very fast firerate");

	//Instigator:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 60, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 62, Ypos + 32);
	Canvas.DrawTile(Texture'Gun_Instigator', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Instigator", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Instigator");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Costs: 1500 gold pieces", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Costs: 1500 gold pieces");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("x25 Damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("x25 Damage");
	Canvas.StrLen("Normal Fire Rate", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Normal Fire Rate");

	//Shredder:
	Ypos += 160;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 380, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 378, Ypos + 32);
	Canvas.DrawTile(Texture'Gun_Shredder', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Shredder", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Shredder");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Costs: 2000 goldpieces", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Costs: 2000 goldpieces");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("x3 Damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("x3 Damage");
	Canvas.StrLen("Very fast firerate", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Very fast firerate");

	//Blaster:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 60, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 62, Ypos + 32);
	Canvas.DrawTile(Texture'Gun_Blaster', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Blaster", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Blaster");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Costs: 2500 gold pieces", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Costs: 2500 gold pieces");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("x3 Damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("x3 Damage");
	Canvas.StrLen("Fast Projectile Speed", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Fast Projectile Speed");

	if (Guns == "Lawgiver")
		{
		FrameX = Canvas.ClipX * 0.5 - 384;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Guns == "Railgun")
		{
		FrameX = Canvas.ClipX * 0.5 + 56;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Guns == "Headremover")
		{
		FrameY += 160;
		FrameX = Canvas.ClipX * 0.5 - 384;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Guns == "Instigator")
		{
		FrameY += 160;
		FrameX = Canvas.ClipX * 0.5 + 56;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Guns == "Shredder")
		{
		FrameY += 320;
		FrameX = Canvas.ClipX * 0.5 - 384;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Guns == "Blaster")
		{
		FrameY += 320;
		FrameX = Canvas.ClipX * 0.5 + 56;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	if ( bNotEneoughGold )
		{
		DrawNotEneoughGold(Canvas);
		}
}


simulated function RenderSpiritualShop(Canvas Canvas)
{
local Info_PRI PRI;
local float XL,YL, Xpos, Ypos;
local float FrameX, FrameY;

	PRI = Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(0, 0);
	Canvas.DrawTile(Texture'HUD_Marble', Canvas.ClipX, Canvas.ClipY, 0, 0, Canvas.ClipX, Canvas.ClipY);

	//Draw Headline:
	Canvas.DrawColor = GreenColor;
	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen(PRI.ShopName, XL, YL);
	Canvas.SetPos(0, 0);
	Canvas.DrawText(PRI.ShopName);
	Canvas.SetPos(0, YL);
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = GoldColor;
	Canvas.DrawText("You have"@PRI.GoldAmount$" goldpieces and"@PRI.Souls$" souls.");
	Ypos = YL * 3; //used to set Y location for the skill tree
	FrameY = YL * 3 - 4; //used to draw frame

	//Draw how to use shop	
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.ClipY - YL * 2);
	Canvas.DrawText("To use the shop open console and type:");
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText("Next = Navigate, Buy = Purchase & Leave = Leave shop.");

	Canvas.bCenter = False;

	//Max Health skill:
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 380, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 378, Ypos + 32);
	Canvas.DrawTile(Texture'Skill_MaxHealth', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Max Health Skill", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Max Health Skill");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Your Current Max Health:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).HealthMax, XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Your Current Max Health:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).HealthMax);
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("+5 to max health", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("+5 to max health");
	Canvas.StrLen("Costs: 300 souls", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Costs: 300 souls");

	//Illumination skill:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 60, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 62, Ypos + 32);
	Canvas.DrawTile(Texture'Skill_Ilumination', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("illumination Skill", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("illumination Skill");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Your Current illumination:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).LightRadius, XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Your Current illumination:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).LightRadius);
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("+1 to Illumination", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("+1 to Illumination");
	Canvas.StrLen("Costs: 400 souls", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Costs: 400 souls");

	//Health Regain skill:
	Ypos += 160;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 380, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 378, Ypos + 32);
	Canvas.DrawTile(Texture'Skill_HealthRegain', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Health Regain Skill", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Health Regain Skill");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).HealthRegain$"/sec", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).HealthRegain$"/sec");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("+1 to health regain", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("+1 to health regain");
	Canvas.StrLen("Costs: 500 souls", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Costs: 500 souls");

	//Ammo Regain skill:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 60, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 62, Ypos + 32);
	Canvas.DrawTile(Texture'Skill_AmmoRegain', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Ammo Regain Skill", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Ammo Regain Skill");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).AmmoRegain$"/sec up to"@PRI.AmmoRegain * 25, XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).AmmoRegain$"/sec up to"@PRI.AmmoRegain * 25);
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("+1 to ammo regain", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("+1 to ammo regain");
	Canvas.StrLen("Costs: 750 souls", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Costs: 750 souls");

	//Add To Damage skill:
	Ypos += 160;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 380, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 378, Ypos + 32);
	Canvas.DrawTile(Texture'Skill_AddToDamage', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Add To Damage Skill", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Add To Damage Skill");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).AddToDamage$"%/hit", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).AddToDamage$"%/hit");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("+1 to Add To Damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("+1 to Add To Damage");
	Canvas.StrLen("Costs: 750 souls", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) - 186 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Costs: 750 souls");

	//Reduce Damage skill:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 + 60, Ypos);
	Canvas.DrawTile(Texture'BlackColor', 320, 128, 0, 0, 320, 128);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 62, Ypos + 32);
	Canvas.DrawTile(Texture'Skill_ReduceDamage', 64, 64, 0, 0, 64, 64);
	Canvas.DrawColor = GoldColor;
	Canvas.StrLen("Reduce Damage Skill", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 2);
	Canvas.DrawText("Reduce Damage Skill");
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.DrawColor = WhiteColor;
	Canvas.StrLen("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).ReduceDamage$"%/hit", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 220 - (0.5 * XL), Ypos + 128 - YL);
	Canvas.DrawText("Your Current Skill Level:"@Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).ReduceDamage$"%/hit");
	Canvas.DrawColor = GreenColor;
	Canvas.StrLen("+1 to reduce damage", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64 - YL );
	Canvas.DrawText("+1 to reduce damage");
	Canvas.StrLen("Costs: 1000 souls", XL, YL);
	Canvas.SetPos( (Canvas.ClipX * 0.5) + 256 - (0.5 * XL), Ypos + 64);
	Canvas.DrawText("Costs: 1000 souls");

	//Draw frame and handle shopping
	if (Skill == "MaxHealth")
		{
		FrameX = Canvas.ClipX * 0.5 - 384;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Skill == "Illumination")
		{
		FrameX = Canvas.ClipX * 0.5 + 56;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Skill == "HealthRegain")
		{
		FrameY += 160;
		FrameX = Canvas.ClipX * 0.5 - 384;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Skill == "AmmoRegain")
		{
		FrameY += 160;
		FrameX = Canvas.ClipX * 0.5 + 56;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Skill == "AddToDamage")
		{
		FrameY += 320;
		FrameX = Canvas.ClipX * 0.5 - 384;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	else if (Skill == "ReduceDamage")
		{
		FrameY += 320;
		FrameX = Canvas.ClipX * 0.5 + 56;
		DrawFrame(Canvas, FrameX, FrameY);
		}
	if ( bNotEneoughSouls )
		{
		DrawNotEneoughSouls(Canvas);
		}

}

simulated function DrawNotEneoughSouls(Canvas Canvas)
{
local float XL,YL;

	Canvas.DrawColor.R = ErrorColor;
	Canvas.DrawColor.G = 0;
	Canvas.DrawColor.B = 0;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, YL * 2);
	if ( bAtMax )
		{
		Canvas.DrawText("This skill is already at max!!");
		}
	else
		{
		Canvas.DrawText("You don't have eneough souls!!");
		}
	ErrorColor -= 5;
	if ( ErrorColor <= 4 )
		{
		bNotEneoughSouls = False;
		bAtMax = False;
		}
}

simulated function DrawNotEneoughGold(Canvas Canvas)
{
local float XL,YL;

	Canvas.DrawColor.R = ErrorColor;
	Canvas.DrawColor.G = 0;
	Canvas.DrawColor.B = 0;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetHugeFont( Canvas.ClipX );
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, YL * 2);
	if ( bAlreadyHasGun )
		{
		Canvas.DrawText("You already have this weapon!!");
		}
	else
		{
		Canvas.DrawText("You don't have eneough gold!!");
		}
	ErrorColor -= 5;
	if ( ErrorColor <= 4 )
		{
		bNotEneoughGold = False;
		bAlreadyHasGun = False;
		}
}

exec function Next()
{
//Spiritual shop
if ( Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bSpiritualShopOpen )
	{
	if (Skill == "MaxHealth")
		{
		Skill = "Illumination";
		}
	else if (Skill == "Illumination")
		{
		Skill = "HealthRegain";
		}
	else if (Skill == "HealthRegain")
		{
		Skill = "AmmoRegain";
		}
	else if (Skill == "AmmoRegain")
		{
		Skill = "AddToDamage";
		}
	else if (Skill == "AddToDamage")
		{
		Skill = "ReduceDamage";
		}
	else if (Skill == "ReduceDamage")
		{
		Skill = "MaxHealth";
		}
	PlayerPawn(Owner).PlaySound (Sound'UnrealShare.flak.Click',,2.0);
	}
//Weapon shop
else if ( Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).bWeaponShopOpen )
	{
	if (Guns == "Lawgiver")
		{
		Guns = "Railgun";
		}
	else if (Guns == "Railgun")
		{
		Guns = "Headremover";
		}
	else if (Guns == "Headremover")
		{
		Guns = "Instigator";
		}
	else if (Guns == "Instigator")
		{
		Guns = "Shredder";
		}
	else if (Guns == "Shredder")
		{
		Guns = "Blaster";
		}
	else if (Guns == "Blaster")
		{
		Guns = "Lawgiver";
		}
	PlayerPawn(Owner).PlaySound (Sound'UnrealShare.flak.Click',,2.0);
	}
}

exec function Leave()
{
	if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bSpiritualShopOpen )
		{
		Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bSpiritualShopOpen = False;
		}
	else if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bWeaponShopOpen )
		{
		Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bWeaponShopOpen = False;
		}
	else if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bInfoOpen )
		{
		bInfoDown = True;
		}
}

exec function Buy()
{
//Spiritual shop skills
if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bSpiritualShopOpen )
	{
	if (Skill == "MaxHealth")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls >= 300 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).HealthMax < 1000)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls -= 300;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).HealthMax += 5;
			PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughSouls = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).HealthMax >= 1000 )
				{
				bAtMax = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Skill == "Illumination")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls >= 400 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).LightRadius < 100)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls -= 400;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).LightRadius += 1;
			PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughSouls = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).LightRadius >= 100 )
				{
				bAtMax = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Skill == "HealthRegain")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls >= 500 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).HealthRegain < 25)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls -= 500;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).HealthRegain += 1;
			PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughSouls = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).HealthRegain >= 25 )
				{
				bAtMax = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Skill == "AmmoRegain")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls >= 750 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).AmmoRegain < 40)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls -= 750;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).AmmoRegain += 1;
			PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughSouls = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).AmmoRegain >= 40 )
				{
				bAtMax = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Skill == "AddToDamage")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls >= 750 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).AddToDamage < 100)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls -= 750;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).AddToDamage += 1;
			PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughSouls = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).AddToDamage >= 100 )
				{
				bAtMax = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Skill == "ReduceDamage")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls >= 1000 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).ReduceDamage < 75)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).Souls -= 1000;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).ReduceDamage += 1;
			PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughSouls = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).ReduceDamage >= 75 )
				{
				bAtMax = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	}

	//weapon shop guns
else if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bWeaponShopOpen )
	{
	if (Guns == "Lawgiver")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount >= 500 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasLawgiver != 1)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount -= 500;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasLawgiver = 1;
			DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Owner),"Monsterhunt2.MH2_Weapon_Lawgiver");
			//PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughGold = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasLawgiver == 1 )
				{
				bAlreadyHasGun = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Guns == "Railgun")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount >= 600 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasRailgun != 1)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount -= 600;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasRailgun = 1;
			DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Owner),"Monsterhunt2.MH2_Weapon_Railgun");
			//PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughGold = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasRailgun == 1 )
				{
				bAlreadyHasGun = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Guns == "Headremover")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount >= 1000 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasHeadremover != 1)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount -= 1000;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasHeadremover = 1;
			DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Owner),"Monsterhunt2.MH2_Weapon_Headremover");
			//PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughGold = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasHeadremover == 1 )
				{
				bAlreadyHasGun = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Guns == "Instigator")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount >= 1500 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasInstigator != 1)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount -= 1500;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasInstigator = 1;
			DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Owner),"Monsterhunt2.MH2_Weapon_Instigator");
			//PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughGold = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasInstigator == 1 )
				{
				bAlreadyHasGun = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Guns == "Shredder")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount >= 2000 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasShredder != 1)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount -= 2000;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasShredder = 1;
			DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Owner),"Monsterhunt2.MH2_Weapon_Shredder");
			//PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughGold = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasShredder == 1 )
				{
				bAlreadyHasGun = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	else if (Guns == "Blaster")
		{
		if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount >= 2500 && Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasBlaster != 1)
			{
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).GoldAmount -= 2500;
			Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasBlaster = 1;
			DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Owner),"Monsterhunt2.MH2_Weapon_Blaster");
			//PlayerPawn(Owner).PlaySound (Sound'UnrealShare.AutoMag.Reload',,2.0);
			}
		else
			{
			bNotEneoughGold = True;
			if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bHasBlaster == 1 )
				{
				bAlreadyHasGun = True;
				}
			ErrorColor=255;
			PlayerPawn(Owner).PlaySound (Sound'UnrealI.Minigun.WindD2',,2.0);
			}
		}
	}	
}

/* The following is just to help calling font size 

GetHugeFont
GetBigFont
GetMediumFont
GetSmallFont
GetSmallestFont
GetAReallySmallFont
GetACompletelyUnreadableFont

*/

simulated function ShowStatAndServerInfo(Canvas Canvas)
{
local Info_GRI GRI;
local float XL,YL, Ypos;

	GRI = Info_GRI(PlayerPawn(Owner).GameReplicationInfo);

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.bCenter = True;

	//Draw ServerName:
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen(GRI.ServerName, XL, YL);
	Canvas.SetPos(0, 1);
	Canvas.DrawText(GRI.ServerName);

	//Draw AdminName And Email:
	Canvas.StrLen("Administrator:"@GRI.AdminName, XL, YL);
	Canvas.SetPos(0, 1 + YL);
	Canvas.DrawText("Administrator:"@GRI.AdminName);
	Canvas.StrLen("Contact:"@GRI.AdminEmail, XL, YL);
	Canvas.SetPos(0, 1 + YL * 2);
	Canvas.DrawText("Contact:"@GRI.AdminEmail);

	//Draw top 10 Players:
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );
	Canvas.StrLen("Test", XL, YL);
	Ypos = Canvas.ClipY * 0.5 - ( 6 * YL );
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText("Top 10 Players:");
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best1$" -"@GRI.Score1);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best2$" -"@GRI.Score2);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best3$" -"@GRI.Score3);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best4$" -"@GRI.Score4);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best5$" -"@GRI.Score5);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best6$" -"@GRI.Score6);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best7$" -"@GRI.Score7);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best8$" -"@GRI.Score8);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best9$" -"@GRI.Score9);
	Ypos += YL;
	Canvas.SetPos(0, Ypos);
	Canvas.DrawText(GRI.Best10$" -"@GRI.Score10);


	Canvas.bCenter = False;
}

//--------------------- RADAR -----------------------

simulated function DrawRadar(Canvas C) 
{
	
	local float Dist;
	local ScriptedPawn P;
	local int XPos, YPos;
	local Vector X,Y,Z, Dir;
	
	GetAxes(Owner.Rotation, X, Y, Z);
	C.Font = Font'WhiteFont';
	C.Style = ERenderStyle.STY_Translucent;

	ShowRaderBase(C);
	ShowRadar(C);
}

simulated function ShowRaderBase(Canvas C) 
{
	
	local float RadarWidth, PulseWidth, PulseBrightness;

	C.Style = ERenderStyle.STY_Translucent;

	C.DrawColor = RadarColor;
	C.SetPos(C.ClipX - 142,C.ClipY * 0.5 - 64);
	C.DrawTile(Texture'Radar', 142, 142, 0, 0, 142, 142);
	
	C.DrawColor = WhiteColor;
	C.SetPos(C.ClipX - 142,C.ClipY * 0.5 - 64);
	C.DrawTile(Texture'RadarBorder', 142, 142, 0, 0, 142, 142);
}

simulated function ShowRadar(Canvas C) 
{
	
	local Pawn P;
	local float Dist, MaxDist, RadarWidth, PulseBrightness, Angle, DotSize, OffsetY, OffsetScale;
	local rotator Dir;
	local vector Start;
	
	LastDrawRadar = Level.TimeSeconds;

	DotSize = 6;

	if (PawnOwner == None)
		Start = PlayerOwner.Location;
	else
		Start = PawnOwner.Location;
	
	C.Style = ERenderStyle.STY_Translucent;
	
	foreach AllActors(class'Pawn', P)
		if (P.Health > 0 && (P.IsA('ScriptedPawn') || P.IsA('Bot') || P.IsA('TournamentPlayer')))
                        {
			
			Dist = VSize(Start - P.Location);
			if (Dist < 3000) {
				if (P.IsA('ScriptedPawn')) 
                                {
					C.DrawColor.R = 255;
					C.DrawColor.G = 0;
					C.DrawColor.B = 0;
				} 
                                else if (P.IsA('Bot') || P.IsA('TournamentPlayer')) 
                                {
					C.DrawColor.R = 0;
					C.DrawColor.B = 0;
					C.DrawColor.G = 255;
				}
				Dir = rotator(P.Location - Start);
				OffsetScale = 0.2 * Dist * 0.000167;
				Angle = ((Dir.Yaw - PlayerOwner.Rotation.Yaw) & 65535) * 6.2832 / 65536;
				C.SetPos(C.ClipX - 71 + OffsetScale * C.ClipX * sin(Angle) - 0.5 * DotSize,C.ClipY * 0.5 + 8 - OffsetScale * C.ClipY * cos(Angle) - 0.5 * DotSize);
				C.DrawTile(Texture'Dots', DotSize, DotSize, 0, 0, 16, 16);
			}
		}            
}

//-------------------- END RADAR ---------------------


function DrawTeamBeacon(Canvas Canvas)
{
	local Pawn 		P;
	local float 	dist;
	local Vector	dir;
	local Vector	loc;
	local byte 		team_id;
	local int		num_used;
	local int 		player_id;
	local int		team_count;
	local int		symbol_count;
	local float		draw_scale;
	local float		interp;
	
	local PlayerReplicationInfo PRI;
	local IdentitySymbol s;

	local float X,Y,Z;

	if (PawnOwner == None)// || !PlayerOwner.Level.Game.bTeamGame)
	{
		return;
	}

	// get the player's information
	team_id = PlayerOwner.PlayerReplicationInfo.Team;
	player_id = PlayerOwner.PlayerReplicationInfo.PlayerID;
	
	num_used = 0;
	team_count = 0;
	symbol_count = 0;
	// count the symbols in the client environment and set them available
	foreach AllActors (class 'IdentitySymbol', s)
	{
		symbol_count++;
		s.bHidden = True; // we use this to set the symbol as 'available' for assignment
	}
	foreach AllActors (class'Pawn', P)
	{
		PRI = P.PlayerReplicationInfo;
		if ( PRI == None )
			continue;
		if ( team_id == PRI.Team && player_id != PRI.PlayerID)
		{
			team_count++;
			if (team_count > symbol_count)// spawn if need more
			{
				s = Spawn(class 'IdentitySymbol', P);
				s.bHidden = P.bHidden;
				s.SetOwner(P);
				symbol_count++;
			}
			else // otherwise, assign a free IdentitySymbol to someone
			{
				foreach AllActors (class 'IdentitySymbol', s)
				{
					if (s.bHidden == True)
					{
						s.bHidden = P.bHidden;
						s.SetOwner(P);
						break;
					}
				}
			}

			// set sprite location above their head
			loc = P.Location;
			loc.z += P.CollisionHeight * 1.75;
			// interp from min/max view distance, to scale the sprite based on distance
			dir = P.Location - PlayerOwner.Location;
			dist = VSize(Dir);
			interp = Dist/32768.0;
		
			// adjust sprite scale if zooming :kludged values:
			interp -= 0.3 * (1.0-(PlayerOwner.FOVAngle / PlayerOwner.DesiredFOV));
			// clamp
			if (interp < 0.0)
				interp = 0.0;
			if (interp > 1.0)
				interp = 1.0;
			draw_scale = Lerp( interp, mMinScale, mMaxScale); 
			s.SetLocation(loc);
			s.DrawScale = draw_scale;
			s.Texture = texture'TeamBeacon';

		}
	}
}

simulated function DrawMonsterName(Canvas C)
{
local string HUDname;	
local float Dist, XL, YL;
local ScriptedPawn S;
local Bot B;
local PlayerPawn P;
local int XPos, YPos;
local Vector X,Y,Z, Dir;
local MH2_Weapon_Lawgiver Lawgiver;
local MH2_Weapon_Railgun Railgun;
local MH2_Weapon_Headremover Headremover;
local MH2_Weapon_Instigator Instigator;
local MH2_Weapon_Shredder Shredder;
local MH2_Weapon_Blaster Blaster;

	GetAxes(Owner.Rotation, X, Y, Z);
	C.Font = MyFonts.GetSmallFont( C.ClipX );
	C.DrawColor = GreenColor;
	C.Style = ERenderStyle.STY_Normal;

	foreach VisibleCollidingActors(class'MH2_Weapon_Blaster',Blaster, 750, Owner.Location, true)
		{
		//Set name to display on HUD
		if (Blaster.WeaponOwner != "")
			HUDname = Blaster.WeaponOwner;
		else
			HUDname = "John Doe";

		Dir = Blaster.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"'s Blaster", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"'s Blaster", true);
			}
		}

	foreach VisibleCollidingActors(class'MH2_Weapon_Shredder',Shredder, 750, Owner.Location, true)
		{
		//Set name to display on HUD
		if (Shredder.WeaponOwner != "")
			HUDname = Shredder.WeaponOwner;
		else
			HUDname = "John Doe";

		Dir = Shredder.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"'s Shredder", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"'s Shredder", true);
			}
		}

	foreach VisibleCollidingActors(class'MH2_Weapon_Instigator',Instigator, 750, Owner.Location, true)
		{
		//Set name to display on HUD
		if (Instigator.WeaponOwner != "")
			HUDname = Instigator.WeaponOwner;
		else
			HUDname = "John Doe";

		Dir = Instigator.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"'s Instigator", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"'s Instigator", true);
			}
		}

	foreach VisibleCollidingActors(class'MH2_Weapon_Headremover',Headremover, 750, Owner.Location, true)
		{
		//Set name to display on HUD
		if (Headremover.WeaponOwner != "")
			HUDname = Headremover.WeaponOwner;
		else
			HUDname = "John Doe";

		Dir = Headremover.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"'s Headremover", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"'s Headremover", true);
			}
		}

	foreach VisibleCollidingActors(class'MH2_Weapon_Railgun',Railgun, 750, Owner.Location, true)
		{
		//Set name to display on HUD
		if (Railgun.WeaponOwner != "")
			HUDname = Railgun.WeaponOwner;
		else
			HUDname = "John Doe";

		Dir = Railgun.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"'s Railgun", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"'s Railgun", true);
			}
		}

	foreach VisibleCollidingActors(class'MH2_Weapon_Lawgiver', Lawgiver, 750, Owner.Location, true)
		{
		//Set name to display on HUD
		if (Lawgiver.WeaponOwner != "")
			HUDname = Lawgiver.WeaponOwner;
		else
			HUDname = "John Doe";

		Dir = Lawgiver.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"'s Lawgiver", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"'s Lawgiver", true);
			}
		}

	foreach VisibleCollidingActors(class'ScriptedPawn', S, 2000, Owner.Location, true)
		{
		//Set name to display on HUD
		if (S.bIsBoss)
			C.DrawColor = GoldColor;
		else
			C.DrawColor = RedColor;
		if (S.Tag != '')
			HUDname = string(S.Tag);
		else
			HUDname = string(S.class.Name);

		Dir = S.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"("$S.Health$")", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"("$S.Health$")", true);
			}
		}
	foreach VisibleCollidingActors(class'Bot', B, 700, Owner.Location, true)
		{
		//Set name to display on HUD

		HUDname = B.PlayerReplicationInfo.PlayerName;

		Dir = B.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"("$B.Health$")", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"("$B.Health$")", true);
			}
		}
	foreach VisibleCollidingActors(class'PlayerPawn', P, 700, Owner.Location, true)
		{
		//Set name to display on HUD

		HUDname = P.PlayerReplicationInfo.PlayerName;

		Dir = P.Location - Owner.Location;
		Dist = VSize(Dir);
		Dir = Dir / Dist;
		C.StrLen(HUDname$"("$P.Health$")", XL, YL);
		if ((Dir Dot X) > 0.7)
			{
			XPos = 0.5 * C.ClipX * (1 + 1.4 * (Dir Dot Y));
			if (XPos < XL)
				{
				XPos = XL;
				}
			if (Xpos > C.ClipX - XL)
				{
				Xpos = C.ClipX - XL;
				}
			YPos = 0.5 * C.ClipY * (1 - 1.4 * (Dir Dot Z));
			C.SetPos(Xpos , YPos );
			C.DrawText(HUDname$"("$P.Health$")", true);
			}
		}
}

simulated function DrawHealthStatus(Canvas Canvas)
{
local float XL, YL, BarSize, HealthPct, PlayerHealth, PlayerHealthBase;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	//Draw Element
	Canvas.SetPos(0, Canvas.ClipY - 128);
	Canvas.DrawTile(Texture'HUD_Statuselement', 64, 128, 0, 0, 64, 128);

	//Draw Health bar
	PlayerHealth = PlayerPawn(Owner).Health;
	PlayerHealthBase = Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).HealthMax;
	HealthPct = PlayerHealth / PlayerHealthBase * 100;
	BarSize = 1.28 * HealthPct;
	if (BarSize > 128 )
		{
		BarSize = 128;
		}
	if (BarSize < 0 )
		{
		BarSize = 0;
		}
	Canvas.SetPos(0, Canvas.ClipY - BarSize);
	if ( HealthPct < 25 )
		{
		Canvas.DrawColor.R = RedPulse;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		if ( bPulseUp )
			{
			RedPulse += 15;
			if ( RedPulse > 255 )
				{
				RedPulse = 255;
				bPulseUp = False;
				}
			}
		else
			{
			RedPulse -= 15;
			if ( RedPulse < 0 )
				{
				RedPulse = 0;
				bPulseUp = True;
				}
			}
		}
	else if ( HealthPct < 35 )
		{
		Canvas.DrawColor = GoldColor;
		}
	else
		{
		Canvas.DrawColor = GreenColor;
		}
	Canvas.DrawTile(Texture'HUD_Healthbar', 64, BarSize, 0, 0, 64, 128);

	//Draw Health icon
	Canvas.SetPos(17, Canvas.ClipY - 121);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'HUD_Hearticon', 32, 32, 0, 0, 64, 64);

	//Draw Health amount
	Canvas.StrLen(int(PlayerHealth), XL, YL);
	Canvas.SetPos((64 - XL) * 0.5, Canvas.ClipY - 144);
	Canvas.DrawText(int(PlayerHealth));
}

simulated function DrawAmmoStatus(Canvas Canvas)
{
local float XL, YL, BarSize, AmmoPct, CurrentAmmo, MaxAmmo;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	if ( PawnOwner.Weapon.AmmoType.AmmoAmount <= 0 )
		{
		return;
		}

	//Draw Element
	Canvas.SetPos(Canvas.ClipX - 64, Canvas.ClipY - 128);
	Canvas.DrawTile(Texture'HUD_Statuselement', 64, 128, 0, 0, 64, 128);

	//Draw Ammo bar
	CurrentAmmo = PawnOwner.Weapon.AmmoType.AmmoAmount;
	MaxAmmo = PawnOwner.Weapon.AmmoType.MaxAmmo;
	AmmoPct = CurrentAmmo / MaxAmmo * 100;
	BarSize = 1.28 * AmmoPct;
	if (BarSize > 128 )
		{
		BarSize = 128;
		}
	if (BarSize < 0 )
		{
		BarSize = 0;
		}
	Canvas.SetPos(Canvas.ClipX - 64, Canvas.ClipY - BarSize);
	if ( AmmoPct < 20 )
		{
		Canvas.DrawColor = RedColor;
		}
	else if ( AmmoPct < 30 )
		{
		Canvas.DrawColor = GoldColor;
		}
	else
		{
		Canvas.DrawColor = GreenColor;
		}
	Canvas.DrawTile(Texture'HUD_Healthbar', 64, BarSize, 0, 0, 64, 128);

	//Draw Ammo icon
	Canvas.SetPos(Canvas.ClipX - 47, Canvas.ClipY - 120);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'HUD_Ammoicon', 32, 32, 0, 0, 64, 64);

	//Draw Ammo amount
	Canvas.StrLen(int(CurrentAmmo), XL, YL);
	Canvas.SetPos(Canvas.ClipX - 64 + ((64 - XL) * 0.5), Canvas.ClipY - 144);
	Canvas.DrawText(int(CurrentAmmo));
}

simulated function DrawArmorAndBootsStatus(Canvas Canvas)
{
local float XL, YL, BarSize, ArmorPct, PlayerArmor, PlayerArmorBase;
local int BootsJumpNums, ScubaCharge, InvisCharge;
local inventory Inv;
local float Xpos;

	Xpos = 130;	//Position to draw the first optional element

	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if (Inv.IsA('UT_JumpBoots'))
			{
			BootsJumpNums = Inv.Charge;
			}
		else if (Inv.IsA('SCUBAGear'))
			{
			ScubaCharge = Inv.Charge;
			}
		else if (Inv.IsA('UT_Invisibility'))
			{
			InvisCharge = Inv.Charge;
			}
		else if (Inv.IsA('MH2_Pickup'))
			{
			PlayerArmor += Inv.Charge;
			PlayerArmorBase += Inv.Default.Charge;
			}
		}
	//PlayerArmorBase = Info_PRI(PlayerPawn(Owner).PlayerReplicationInfo).MaxArmor;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	//Draw Boots
	if ( BootsJumpNums > 0 )
		{
		Canvas.SetPos(Xpos, Canvas.ClipY - 64);
		Canvas.DrawTile(Texture'HUD_Bootselement', 64, 64, 0, 0, 64, 64);
		Canvas.StrLen(BootsJumpNums, XL, YL);
		Canvas.SetPos(Xpos +  32 - (0.5 * XL), Canvas.ClipY - 57);
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawText(BootsJumpNums);
		Xpos += 65;
		}

	//Draw Scuba
	if ( ScubaCharge > 0 )
		{
		Canvas.SetPos(Xpos, Canvas.ClipY - 64);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawTile(Texture'HUD_Scubagear', 64, 64, 0, 0, 64, 64);
		Canvas.StrLen(ScubaCharge, XL, YL);
		Canvas.SetPos(Xpos +  32 - (0.5 * XL), Canvas.ClipY - 57);
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawText(ScubaCharge);
		Xpos += 65;
		}

	Xpos = Canvas.ClipX - 129;

	//Draw Invisibility
	if ( InvisCharge > 0 )
		{
		Canvas.SetPos(Xpos, Canvas.ClipY - 64);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawTile(Texture'HUD_Invis', 64, 64, 0, 0, 64, 64);
		Canvas.StrLen(InvisCharge, XL, YL);
		Canvas.SetPos(Xpos +  32 - (0.5 * XL), Canvas.ClipY - 57);
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawText(InvisCharge);
		Xpos -= 65;
		}

	//Draw Armor Element
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(65, Canvas.ClipY - 128);
	Canvas.DrawTile(Texture'HUD_Statuselement', 64, 128, 0, 0, 64, 128);

	//Draw Armor bar
	ArmorPct = PlayerArmor / PlayerArmorBase * 100;
	BarSize = 1.28 * ArmorPct;
	if (BarSize > 128 )
		{
		BarSize = 128;
		}
	if (BarSize < 0 )
		{
		BarSize = 0;
		}
	Canvas.SetPos(65, Canvas.ClipY - BarSize);
	if ( ArmorPct < 20 )
		{
		Canvas.DrawColor = RedColor;
		}
	else if ( ArmorPct < 30 )
		{
		Canvas.DrawColor = GoldColor;
		}
	else
		{
		Canvas.DrawColor = GreenColor;
		}
	Canvas.DrawTile(Texture'HUD_Healthbar', 64, BarSize, 0, 0, 64, 128);

	//Draw Armor icon
	Canvas.SetPos(82, Canvas.ClipY - 120);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawTile(Texture'HUD_Armoricon', 32, 32, 0, 0, 64, 64);

	//Draw Armor amount
	Canvas.StrLen(int(PlayerArmor), XL, YL);
	Canvas.SetPos((64 - XL) * 0.5 + 65, Canvas.ClipY - 144);
	Canvas.DrawText(int(PlayerArmor));
}

simulated function DrawWeaponName(Canvas Canvas)
{
local float XL, YL, BarSize, AmmoPct, CurrentAmmo, MaxAmmo;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );

	if ( PawnOwner.Weapon.ItemName == "" )
		{
		return;
		}
	Canvas.StrLen(PawnOwner.Weapon.ItemName, XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - (XL * 0.5), Canvas.ClipY - YL * 2);
	Canvas.DrawText(PawnOwner.Weapon.ItemName);
}

simulated function DrawPlayerScoreAndRank(Canvas Canvas)
{
local float XL, YL;
local Info_PRI IPRI;

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("score:"@int(PawnOwner.PlayerReplicationInfo.Score), XL, YL);
	Canvas.SetPos(Canvas.ClipX * 0.5 - (XL * 0.5), Canvas.ClipY - YL);
	Canvas.DrawText("score:"@int(PawnOwner.PlayerReplicationInfo.Score));
}

simulated function DrawMvsH(Canvas Canvas)
{
local float XL, YL;
local int Monsters, Hunters;
local Info_GRI IPRI;

	Monsters = Info_GRI(PlayerPawn(Owner).GameReplicationInfo).Monsters;
	Hunters = Info_GRI(PlayerPawn(Owner).GameReplicationInfo).Hunters;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	//draw F2 add
	Canvas.StrLen("Hit F2 to see top 10 players", XL, YL);
	Canvas.SetPos(Canvas.ClipX  * 0.5 - 0.5 * XL, 0);
	Canvas.DrawText("Hit F2 to see top 10 players");

	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen("Monsters:"@Monsters, XL, YL);
	Canvas.SetPos(Canvas.ClipX - XL, 0);
	Canvas.DrawText("Monsters:"@Monsters);
	Canvas.StrLen("Hunters:"@Hunters, XL, YL);
	Canvas.SetPos(Canvas.ClipX - XL, YL);
	Canvas.DrawText("Hunters:"@Hunters);
}

//This function calls all the custom functions
simulated function DrawGameSynopsis(Canvas Canvas)
{
	DrawHealthStatus(Canvas);
	DrawAmmoStatus(Canvas);
	DrawArmorAndBootsStatus(Canvas);
	DrawWeaponName(Canvas);
	DrawPlayerScoreAndRank(Canvas);
	DrawMvsH(Canvas);
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function SetDamage(vector HitLoc, float damage)
{
	local int i, best;
	local vector X,Y,Z;
	local float Max, XOffset, YOffset;

	if ( Level.bDropDetail || !PlayerOwner.IsA('TournamentPlayer') )
		return;

	for ( i=0; i<4; i++ )
		if ( Level.TimeSeconds - HitTime[i] > Max )
		{
			best = i;	
			Max = Level.TimeSeconds - HitTime[i];
		}

	HitTime[best] = Level.TimeSeconds;
	HitDamage[best] = FClamp(Damage * 0.06,2,4);
	GetAxes(Owner.Rotation,X,Y,Z);
	XOffset = - 0.5 * FClamp((Y Dot HitLoc)/CollisionRadius , -1, 1);
	YOffset = -0.5 * FClamp((Z Dot HitLoc)/CollisionHeight , -1, 1);

	// hack for positions around head or near legs
	if ( YOffset < -0.35 )
	{
		XOffset *= 0.3;
		YOffset = FMax(HitPos[best].Y, -0.45);
	}
	else if ( YOffset > 0.1 )
	{
		if ( abs(XOffset) < 0.25 )
		{
			if ( XOffset > 0 )
				XOffset = 0.25;
			else
				XOffset = -0.25;
		}				
		YOffset = FMin(YOffset, 0.4);
	}

	HitPos[best].X = 128 * (0.5 + XOffset) - 0.5 * 25 * HitDamage[best];
	HitPos[best].Y = 256 * (0.5 + YOffset) - 0.5 * HitDamage[Best] * 64;
}

simulated function PostBeginPlay()
{
	local int i;

	if ( Level.NetMode != NM_Standalone )
		MOTDFadeOutTime = 350;
	FaceAreaOffset = -64;
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(FontInfoClass, class'Class'))));
	Super.PostBeginPlay();
	SetTimer(1.0, True);

	if ( (PlayerPawn(Owner).GameReplicationInfo != None)
		&& (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

	ServerInfo = Spawn(ServerInfoClass, Owner);
}

exec function SetHUDR(int n)
{
	FavoriteHUDColor.R = Clamp(n,0,16);
}

exec function SetHUDG(int n)
{
	FavoriteHUDColor.G = Clamp(n,0,16);
}

exec function SetHUDB(int n)
{
	FavoriteHUDColor.B = Clamp(n,0,16);
}

exec function ShowServerInfo()
{
	if (bShowInfo)
	{
		bShowInfo = False;
	} else {
		bShowInfo = True;
		PlayerPawn(Owner).bShowScores = False;
	}
}

exec function GrowHUD()
{
	if ( bHideHUD )
		bHideHud = false;
	else if ( bHideAmmo )
		bHideAmmo = false;
	else if ( bHideFrags )
		bHideFrags = false;
	else if ( bHideTeamInfo )
		bHideTeamInfo = false;
	else if ( bHideAllWeapons )
		bHideAllWeapons = false;
	else if ( bHideStatus )
		bHideStatus = false;
	else 
		WeaponScale = 1.0;

	SaveConfig();
}

exec function ShrinkHUD()
{
	if ( !bLowRes && (WeaponScale * HUDScale > 0.8) )
		WeaponScale = 0.8/HUDScale;
	else if ( !bHideStatus )
		bHideStatus = true;
	else if ( !bHideAllWeapons )
		bHideAllWeapons = true;
	else if ( !bHideTeamInfo )
		bHideTeamInfo = true;
	else if ( !bHideFrags )
		bHideFrags = true;
	else if ( !bHideAmmo )
		bHideAmmo = true;
	else
		bHideHud = true;

	SaveConfig();
}
	
simulated function ChangeCrosshair(int d)
{
	Crosshair = Crosshair + d;
	if ( Crosshair >= CrossHairCount )
		Crosshair = 0;
	else
	if ( Crosshair < 0 )
		Crosshair = CrossHairCount-1;
}

simulated function Texture LoadCrosshair(int c)
{
	CrossHairTextures[c] = Texture(DynamicLoadObject(CrossHairs[c], class'Texture'));
	return CrossHairTextures[c];
}

simulated function HUDSetup(canvas canvas)
{
	local int FontSize;

	bResChanged = (Canvas.ClipX != OldClipX);
	OldClipX = Canvas.ClipX;
		
	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner.ViewTarget == None )
		PawnOwner = PlayerOwner;
	else if ( PlayerOwner.ViewTarget.bIsPawn )
		PawnOwner = Pawn(PlayerOwner.ViewTarget);
	else 
		PawnOwner = PlayerOwner;

	// Setup the way we want to draw all HUD elements
	Canvas.Reset();
	Canvas.SpaceX=0;
	Canvas.bNoSmooth = True;

	FontSize = Min(3, HUDScale * Canvas.ClipX/500);
	Scale = (HUDScale * Canvas.ClipX)/1280.0;

	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );

	SolidHUDColor = FavoriteHUDColor * 15.9;
	if ( (Opacity == 16) || !Level.bHighDetailMode )
	{
		Style = ERenderStyle.STY_Normal;
		BaseColor = WhiteColor;
		HUDColor = SolidHUDColor;
	}
	else
	{
		Style = ERenderStyle.STY_Translucent;
		BaseColor = (16 * Opacity + 15) * UnitColor;
		HUDColor = FavoriteHUDColor * (Opacity + 0.9);
	}
	Canvas.DrawColor = BaseColor;
	Canvas.Style = Style;
	bLowRes = ( Canvas.ClipX < 400 );
	if ( bLowRes )
		WeaponScale = 1.0;
}

simulated function DrawDigit(Canvas Canvas, int d, int Step, float UpScale, out byte bMinus )
{
	if ( bMinus == 1 )
	{
		Canvas.CurX -= Step;
		Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, 0, 64, 25.0, 64.0);
		bMinus = 0;
	}
	if ( d == 1 )
		Canvas.CurX -= 0.625 * Step;
	else
		Canvas.CurX -= 0.25 * Step;		
	Canvas.DrawTile(Texture'BotPack.HudElements1', UpScale*25, 64*UpScale, d*25, 0, 25.0, 64.0);
	Canvas.CurX += 7*UpScale;
}

// DrawBigNum should already have Canvas set up
// X and Y should be the left most allowed position of the number (will be adjusted right if possible)
simulated function DrawBigNum(Canvas Canvas, int Value, int X, int Y, optional float ScaleFactor)
{
	local int d, Mag, Step;
	local float UpScale;
	local byte bMinus;

	if ( ScaleFactor != 0 )
		UpScale = Scale * ScaleFactor;
	else
		UpScale = Scale;

	Canvas.CurX = X;	
	Canvas.CurY = Y;
	Step = 16 * UpScale;
	if ( Value < 0 )
		bMinus = 1;
	Mag = FMin(9999, Abs(Value));

	if ( Mag >= 1000 )
	{
		Canvas.CurX -= Step;
		d = 0.001 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 1000 * d;
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else if ( Mag >= 100 )
	{
		d = 0.01 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 100 * d;
	}
	else
		Canvas.CurX += Step;

	if ( Mag >= 10 )
	{
		d = 0.1 * Mag;
		DrawDigit(Canvas, d, Step, UpScale, bMinus);
		Mag = Mag - 10 * d;
	}
	else if ( d > 0 )
		DrawDigit(Canvas, 0, Step, UpScale, bMinus);
	else
		Canvas.CurX += Step;

	DrawDigit(Canvas, Mag, Step, UpScale, bMinus);
}

simulated function DisplayProgressMessage( canvas Canvas )
{
	local int i;
	local float XL, YL, YOffset;
	local GameReplicationInfo GRI;

	PlayerOwner.ProgressTimeOut = FMin(PlayerOwner.ProgressTimeOut, Level.TimeSeconds + 8);
	Canvas.Style = ERenderStyle.STY_Normal;	

	Canvas.bCenter = True;
	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	if ( UTIntro(Level.Game) != None )
		YOffset = 64 * scale + 2 * YL;
	else if ( (MOTDFadeOutTime <= 0) || (Canvas.ClipY < 300) )
		YOffset = 64 * scale + 6 * YL;
	else
	{
		YOffset = 64 * scale + 6 * YL;
		GRI = PlayerOwner.GameReplicationInfo;
		if ( GRI != None )
		{
			if ( GRI.MOTDLine1 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine2 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine3 != "" )
				YOffset += YL;
			if ( GRI.MOTDLine4 != "" )
				YOffset += YL;
		}
	}
	for (i=0; i<8; i++)
	{
		Canvas.SetPos(0, YOffset);
		Canvas.DrawColor = PlayerPawn(Owner).ProgressColor[i];
		Canvas.DrawText(PlayerPawn(Owner).ProgressMessage[i], False);
		YOffset += YL + 1;
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.bCenter = False;
	HUDSetup(Canvas);	
}

function DrawTalkFace(Canvas Canvas, int i, float YPos)
{
	if ( !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator )
	{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(FaceAreaOffset + 4*Scale, 4*Scale);
		Canvas.DrawTile(FaceTexture, YPos - 1*Scale, YPos - 1*Scale, 0, 0, FaceTexture.USize, FaceTexture.VSize);
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawColor = FaceColor;
		Canvas.SetPos(FaceAreaOffset, 0);
		Canvas.DrawTile(texture'LadrStatic.Static_a00', YPos + 7*Scale, YPos + 7*Scale, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);
		Canvas.DrawColor = WhiteColor;
	}
}

function bool DrawSpeechArea( Canvas Canvas, float XL, float YL )
{
	local float YPos, Yadj;
	local float WackNumber;
	local int paneltype;

	YPos = FMax(YL*4 + 8, 70*Scale);
	Yadj = YPos + 7*Scale;
	YPos *=2;
	MinFaceAreaOffset = -1 * Yadj;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = HUDColor * MessageFadeTime;

	Canvas.SetPos(FaceAreaOffset, 0);
	Canvas.DrawTile(texture'LadrStatic.Static_a00', Yadj, Yadj, 0, 0, texture'LadrStatic.Static_a00'.USize, texture'LadrStatic.Static_a00'.VSize);

	WackNumber = 512*Scale - 64 + FaceAreaOffset; // 256*Scale - (512*Scale - (768*Scale - 64 + FaceAreaOffset));
	if ( !PlayerOwner.Player.Console.bTyping )
		paneltype = 0;
	else 
	{
		Canvas.StrLen("(>"@PlayerOwner.Player.Console.TypedStr$"_", XL, YL);
		if (XL < 768*Scale)
			paneltype = 1;
		else 
			paneltype = 2;
	}
}

//========================================
// Master HUD render function.

simulated function PostRender( canvas Canvas )
{
	local float XL, YL, XPos, YPos, FadeValue;
	local string Message;
	local int M, i, j, k, XOverflow;
	local float OldOriginX;

	HUDSetup(canvas);

	if ( !bIntroRendered )
		{
		RenderIntro(Canvas);
		return;
		}
	if ( bIntroRendered && !bWhiteColorDone )
		{
		WhiteColor.R = IntroColor;
		WhiteColor.G = IntroColor;
		WhiteColor.B = IntroColor;
		IntroColor += 4;
		if ( IntroColor >= 255 )
			{
			WhiteColor.R = 255;
			WhiteColor.G = 255;
			WhiteColor.B = 255;
			bWhiteColorDone = True;
			}
		}


	if ( (PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None) )
		return;

	if ( bShowInfo )
		{
		ShowStatAndServerInfo(Canvas);
		return;
		}

	//Check if the player is in a shop
	if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bSpiritualShopOpen )
		{
		RenderSpiritualShop(Canvas);
		return;
		}
	else if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bWeaponShopOpen )
		{
		RenderWeaponShop(Canvas);
		return;
		}
	else if ( Info_PRI(PlayerPawn(Owner).PlayerreplicationInfo).bInfoOpen )
		{
		RenderInfo(Canvas);
		return;
		}

	//Call custom functions:
	DrawRadar(Canvas);
	DrawTeamBeacon(Canvas);
	DrawMonsterName(Canvas);
	if ( !PlayerOwner.bShowScores && !bForceScores )
		{
		DrawTimeElapsed(canvas);
		}
	
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	OldOriginX = Canvas.OrgX;
	// Master message short queue control loop.
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("TEST", XL, YL);
	Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
	bDrawFaceArea = false;
	if ( !bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD 
			&& !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4) )
	{
		DrawSpeechArea(Canvas, XL, YL);
		bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
		if ( bDrawFaceArea )
		{
			if ( !bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator) )
				Canvas.SetOrigin( FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY );
		}
	}

	for (i=0; i<4; i++)
	{
		if ( ShortMessageQueue[i].Message != None )
		{
			j++;

			if ( bResChanged || (ShortMessageQueue[i].XL == 0) )
			{
				if ( ShortMessageQueue[i].Message.Default.bComplexString )
					Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString( 
											self,
											ShortMessageQueue[i].Switch,
											ShortMessageQueue[i].RelatedPRI,
											ShortMessageQueue[i].StringMessage), 
								   ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				else
					Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
				Canvas.StrLen("TEST", XL, YL);
				ShortMessageQueue[i].numLines = 1;
				if ( ShortMessageQueue[i].YL > YL )
				{
					ShortMessageQueue[i].numLines++;
					for (k=2; k<4-i; k++)
					{
						if (ShortMessageQueue[i].YL > YL*k)
							ShortMessageQueue[i].numLines++;
					}
				}
			}

			// Keep track of the amount of lines a message overflows, to offset the next message with.
			Canvas.SetPos(6, 2 + YL * YPos);
			YPos += ShortMessageQueue[i].numLines;
			if ( YPos > 4 )
				break; 

			if ( ShortMessageQueue[i].Message.Default.bComplexString )
			{
				// Use this for string messages with multiple colors.
				ShortMessageQueue[i].Message.Static.RenderComplexMessage( 
					Canvas,
					ShortMessageQueue[i].XL,  YL,
					ShortMessageQueue[i].StringMessage,
					ShortMessageQueue[i].Switch,
					ShortMessageQueue[i].RelatedPRI,
					None,
					ShortMessageQueue[i].OptionalObject
					);				
			} 
			else
			{
				Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
				Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
		}
	}

	Canvas.DrawColor = WhiteColor;
	Canvas.SetClip(OldClipX, Canvas.ClipY);
	Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

	if ( PlayerOwner.bShowScores || bForceScores )
	{
		if ( (PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None) )
			PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
		if ( PlayerOwner.Scoring != None )
		{ 
			PlayerOwner.Scoring.OwnerHUD = self;
			PlayerOwner.Scoring.ShowScores(Canvas);
			if ( PlayerOwner.Player.Console.bTyping )
				DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
			return;
		}
	}

	YPos = FMax(YL*4 + 8, 70*Scale);
	if ( bDrawFaceArea )
		DrawTalkFace( Canvas,0, YPos );
	if (j > 0) 
	{
		bDrawMessageArea = True;
		MessageFadeCount = 2;
	} 
	else 
		bDrawMessageArea = False;

	if ( !bHideCenterMessages )
	{
		// Master localized message control loop.
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message != None)
			{
				if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
				{
					Canvas.Style = ERenderStyle.STY_Translucent;
					FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
					if (FadeValue > 0.0)
					{
						if ( bResChanged || (LocalMessages[i].XL == 0) )
						{
							if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
								LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
							else // ==2
								LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
							Canvas.Font = LocalMessages[i].StringFont;
							Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
							LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
						}
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
						Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
						Canvas.DrawText( LocalMessages[i].StringMessage, False );
					}
				} 
				else 
				{
					if ( bResChanged || (LocalMessages[i].XL == 0) )
					{
						if ( LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1 )
							LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
						else // == 2
							LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );
						Canvas.Font = LocalMessages[i].StringFont;
						Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
						LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
					}
					Canvas.Font = LocalMessages[i].StringFont;
					Canvas.Style = ERenderStyle.STY_Normal;
					Canvas.DrawColor = LocalMessages[i].DrawColor;
					Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
					Canvas.DrawText( LocalMessages[i].StringMessage, False );
				}
			}
		}
	}
	Canvas.Style = ERenderStyle.STY_Normal;

	if ( !PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None) )
	{
		Canvas.DrawColor = WhiteColor;
		PawnOwner.Weapon.PostRender(Canvas);
		if ( !PawnOwner.Weapon.bOwnsCrossHair )
			DrawCrossHair(Canvas, 0,0 );
	}

	if ( (PawnOwner != Owner) && PawnOwner.bIsPlayer )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		Canvas.bCenter = true;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = CyanColor * TutIconBlink;
		Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
		Canvas.DrawText( LiveFeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
		Canvas.bCenter = false;
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = Style;
	}

	if ( bStartUpMessage && (Level.TimeSeconds < 5) )
	{
		bStartUpMessage = false;
		PlayerOwner.SetProgressTime(7);
	}
	if ( (PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages )
		DisplayProgressMessage(Canvas);
		 
	if( !bHideHUD )
	{
		if ( !PawnOwner.PlayerReplicationInfo.bIsSpectator )
		{
			Canvas.Style = Style;
		}

		DrawGameSynopsis(Canvas);

		if ( HUDMutator != None )
			HUDMutator.PostRender(Canvas);

		if ( (PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) ) 
		{
			if ( TimeMessageClass == None )
				TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

			if ( (PlayerOwner.GameReplicationInfo.RemainingTime <= 300)
			  && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime) )
			{
				LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
				if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 30 )
				{
					bTimeValid = ( bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) );	
					if ( PlayerOwner.GameReplicationInfo.RemainingTime == 30 )
						TellTime(5);
					else if ( bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10 )
						TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
				}
				else if ( PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0 )
				{
					M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
					TellTime(5 - M);
				}
			}
		}
	}
	if ( PlayerOwner.Player.Console.bTyping )
		DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

	if ( PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5) )
	{
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.DrawColor = WhiteColor;
		Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
		Canvas.DrawIcon(texture'DisconnectWarn', Scale);
	}
}

function Timer()
{
	local int i, j;

	if (!bDrawMessageArea)
	{
		if (MessageFadeCount > 0)
			MessageFadeCount--;
	}

	// Age the short message queue.
	for (i=0; i<4; i++)
	{
		// Purge expired messages.
		if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
			ClearMessage(ShortMessageQueue[i]);
	}

	// Clean empty slots.
	for (i=0; i<3; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			for (j=i; j<4; j++)
			{
				if ( ShortMessageQueue[j].Message != None )
				{
					CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
					ClearMessage(ShortMessageQueue[j]);
					break;
				}
			}
		}
	}

	// Age all localized messages.
	for (i=0; i<10; i++)
	{
		// Purge expired messages.
		if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
			ClearMessage(LocalMessages[i]);
	}

	// Clean empty slots.
	for (i=0; i<9; i++)
	{
		if ( LocalMessages[i].Message == None )
		{
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);
			ClearMessage(LocalMessages[i+1]);
		}
	}

	if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None)
		|| (PawnOwner.PlayerReplicationInfo == None) )
		return;

	// Update the rank and spread.
	UpdateRankAndSpread();
}

function UpdateRankAndSpread()
{
	local PlayerReplicationInfo PRI;
	local int HighScore;
	local int i, j;

	PlayerCount = 0;
	HighScore = -100;
	bTiedScore = False;
	Rank = 1;
	for (i=0; i<32; i++)
	{
		PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
		if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
		{
			PlayerCount++;
			if (PRI != PawnOwner.PlayerReplicationInfo)
			{
				if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
					Rank += 1;
				else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
				{
					bTiedScore = True;
					if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
						Rank += 1;
					else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
						if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
							Rank += 1;
				}
				if (PRI.Score > HighScore)
					HighScore = PRI.Score;
			}
		}
	}
	Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

simulated function TellTime(int num)
{
	PlayerOwner.ReceiveLocalizedMessage( TimeMessageClass, Num );
}

simulated function Tick(float DeltaTime)
{
	local int i;

	Super.Tick(DeltaTime);

	IdentifyFadeTime = FMax(0.0, IdentifyFadeTime - DeltaTime);
	MOTDFadeOutTime = FMax(0.0, MOTDFadeOutTime - DeltaTime * 55);
	
	TutIconBlink += DeltaTime;
	if (TutIconBlink >= 0.5)
		TutIconBlink = 0.0;

	if ( bDrawFaceArea )
	{
		if ( FaceAreaOffset < 0 )
			FaceAreaOffset += DeltaTime * 600;
		if ( FaceAreaOffset > 0 )
			FaceAreaOffset = 0.0;
	} 
	else if ( FaceAreaOffset > MinFaceAreaOffset )
		FaceAreaOffset = FMax(FaceAreaOffset - DeltaTime * 600, MinFaceAreaOffset );

	if ( bDrawMessageArea )
	{
		if ( MessageFadeTime < 1.0 )
		{
			MessageFadeTime += DeltaTime * 8;
			if (MessageFadeTime > 1.0)
				MessageFadeTime = 1.0;
		}
	} 
	else if ( (MessageFadeTime > 0.0) && (MessageFadeCount == 0) )
	{
		MessageFadeTime -= DeltaTime * 2;
		if (MessageFadeTime < 0.0)
			MessageFadeTime = 0.0;
	}
	WeaponNameFade -= DeltaTime;
}

simulated function DrawMOTD(Canvas Canvas)
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local float InitialY;

	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	Canvas.Style = Style;
	Canvas.bCenter = true;
	Canvas.DrawColor = WhiteColor;

	Canvas.SetPos(0, 0);
	Canvas.StrLen("TEST", XL, YL);
	Canvas.DrawText(GRI.ServerName);

	Canvas.SetPos(0, YL);
	Canvas.DrawText(GRI.GameName, true);
	Canvas.SetPos(0, 2*YL);
	Canvas.DrawText("Battleground:"@Level.Title$", Author:"@Level.Author, true);

	Canvas.bCenter = false;
}

simulated function DrawCrossHair( canvas Canvas, int X, int Y)
{
	local float XScale, PickDiff;
	local float XLength;
	local texture T;

 	if (Crosshair>=CrosshairCount) Return;
	if ( Canvas.ClipX < 512 )
		XScale = 0.5;
	else
		XScale = FMax(1, int(0.1 + Canvas.ClipX/640.0));
	PickDiff = Level.TimeSeconds - PickupTime;
	if ( PickDiff < 0.4 )
	{
		if ( PickDiff < 0.2 )
			XScale *= (1 + 5 * PickDiff);
		else
			XScale *= (3 - 5 * PickDiff);
	}
	XLength = XScale * 64.0;

	Canvas.bNoSmooth = False;
	if ( PlayerOwner.Handedness == -1 )
		Canvas.SetPos(0.503 * (Canvas.ClipX - XLength), 0.504 * (Canvas.ClipY - XLength));
	else if ( PlayerOwner.Handedness == 1 )
		Canvas.SetPos(0.497 * (Canvas.ClipX - XLength), 0.496 * (Canvas.ClipY - XLength));
	else
		Canvas.SetPos(0.5 * (Canvas.ClipX - XLength), 0.5 * (Canvas.ClipY - XLength));
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawColor = 15 * CrosshairColor;

	T = CrossHairTextures[Crosshair];
	if( T == None )
		T = LoadCrosshair(Crosshair);

	Canvas.DrawTile(T, XLength, XLength, 0, 0, 64, 64);
	Canvas.bNoSmooth = True;
	Canvas.Style = Style;
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
	local string TypingPrompt;
	local float XL, YL, YPos, XOffset;
	local float MyOldClipX, OldClipY, OldOrgX, OldOrgY;

	MyOldClipX = Canvas.ClipX;
	OldClipY = Canvas.ClipY;
	OldOrgX = Canvas.OrgX;
	OldOrgY = Canvas.OrgY;

	Canvas.DrawColor = GreenColor;
	TypingPrompt = "(>"@Console.TypedStr$"_";
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen( "TEST", XL, YL );
	YPos = YL*4 + 8;
	if (PawnOwner.PlayerReplicationInfo.bIsSpectator || bHideHUD || bHideFaces)
		XOffset = 0;
	else
		XOffset = FMax(0,FaceAreaOffset + 15*Scale + YPos);
	Canvas.SetOrigin(XOffset, FMax(0,YPos + 7*Scale));
	Canvas.SetClip( 760*Scale, Canvas.ClipY );
	Canvas.SetPos( 0, 0 );
	Canvas.DrawText( TypingPrompt, false );
	Canvas.SetOrigin( OldOrgX, OldOrgY );
	Canvas.SetClip( MyOldClipX, OldClipY );
}

// Entry point for string messages.
simulated function Message( PlayerReplicationInfo PRI, coerce string Msg, name MsgType )
{
	local int i;
	local Class<LocalMessage> MessageClass;

	switch (MsgType)
	{
		case 'Say':
		case 'TeamSay':
			MessageClass = class'SayMessagePlus';
			break;
		case 'CriticalEvent':
			MessageClass = class'CriticalStringPlus';
			LocalizedMessage( MessageClass, 0, None, None, None, Msg );
			return;
		case 'DeathMessage':
			MessageClass = class'RedSayMessagePlus';
			break;
		case 'Pickup':
			PickupTime = Level.TimeSeconds;
		default:
			MessageClass = class'StringMessagePlus';
			break;
	}

	if ( ClassIsChildOf(MessageClass, class'SayMessagePlus') || 
				     ClassIsChildOf(MessageClass, class'TeamSayMessagePlus') )
	{
		FaceTexture = PRI.TalkTexture;
		if ( FaceTexture != None )
			FaceTime = Level.TimeSeconds + 3;
		if ( Msg == "" )
			return;
	} 
	for (i=0; i<6; i++)
	{
		if ( ShortMessageQueue[i].Message == None )
		{
			// Add the message here.
			ShortMessageQueue[i].Message = MessageClass;
			ShortMessageQueue[i].Switch = 0;
			ShortMessageQueue[i].RelatedPRI = PRI;
			ShortMessageQueue[i].OptionalObject = None;
			ShortMessageQueue[i].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
			if ( MessageClass.Default.bComplexString )
				ShortMessageQueue[i].StringMessage = Msg;
			else
				ShortMessageQueue[i].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
			return;
		}
	}

	// No empty slots.  Force a message out.
	for (i=0; i<5; i++)
		CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

	ShortMessageQueue[5].Message = MessageClass;
	ShortMessageQueue[5].Switch = 0;
	ShortMessageQueue[5].RelatedPRI = PRI;
	ShortMessageQueue[5].OptionalObject = None;
	ShortMessageQueue[5].EndOfLife = MessageClass.Default.Lifetime + Level.TimeSeconds;
	if ( MessageClass.Default.bComplexString )
		ShortMessageQueue[5].StringMessage = Msg;
	else
		ShortMessageQueue[5].StringMessage = MessageClass.Static.AssembleString(self,0,PRI,Msg);
}

simulated function bool DisplayMessages( canvas Canvas )
{
	return true;
}

simulated function float DrawNextMessagePart(Canvas Canvas, string MString, float XOffset, int YPos)
{
	local float XL, YL;

	Canvas.SetPos(4 + XOffset, YPos);
	Canvas.StrLen( MString, XL, YL );
	Canvas.DrawText( MString, false );
	return (XOffset + XL);
}

//================================================================================
// Identify Info

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = PawnOwner.Location;
	StartTrace.Z += PawnOwner.BaseEyeHeight;
	EndTrace = StartTrace + vector(PawnOwner.ViewRotation) * 1000.0;
	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( Pawn(Other) != None )
	{
		if ( Pawn(Other).bIsPlayer && !Other.bHidden )
		{
			IdentifyTarget = Pawn(Other).PlayerReplicationInfo;
			IdentifyFadeTime = 3.0;
		}
	}
	else if ( (Other != None) && SpecialIdentify(Canvas, Other) )
		return false;

	if ( (IdentifyFadeTime == 0.0) || (IdentifyTarget == None) || IdentifyTarget.bFeigningDeath )
		return false;

	return true;
}

simulated function bool SpecialIdentify(Canvas Canvas, Actor Other )
{
	return false;
}

simulated function SetIDColor( Canvas Canvas, int type )
{
	Canvas.DrawColor = GreenColor;
	if ( type == 0 )
		Canvas.DrawColor.G = 160 * (IdentifyFadeTime / 3.0);
	else
		Canvas.DrawColor.G = 255 * (IdentifyFadeTime / 3.0);
}

simulated function DrawTwoColorID( canvas Canvas, string TitleString, string ValueString, int YStart )
{
	local float XL, YL, XOffset, X1;

	Canvas.Style = Style;
	Canvas.StrLen(TitleString$": ", XL, YL);
	X1 = XL;
	Canvas.StrLen(ValueString, XL, YL);
	XOffset = Canvas.ClipX/2 - (X1+XL)/2;
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,0);
	XOffset += X1;
	Canvas.DrawText(TitleString);
	Canvas.SetPos(XOffset, YStart);
	SetIDColor(Canvas,1);
	Canvas.DrawText(ValueString);
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
}
	
simulated function bool DrawIdentifyInfo(canvas Canvas)
{
	if ( !TraceIdentify(Canvas))
		return false;

	if( IdentifyTarget.PlayerName != "" )
	{
		Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
		DrawTwoColorID(Canvas,IdentifyName, IdentifyTarget.PlayerName, Canvas.ClipY - 256 * Scale);
	}
	return true;
}

//=====================================================================
// Deal with a localized message.

simulated function LocalizedMessage( class<LocalMessage> Message, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject, optional String CriticalString )
{
	local int i;

	if ( ClassIsChildOf( Message, class'PickupMessagePlus' ) )
		PickupTime = Level.TimeSeconds;

	if ( !Message.Default.bIsSpecial )
	{
		if ( ClassIsChildOf(Message, class'SayMessagePlus') || 
						 ClassIsChildOf(Message, class'TeamSayMessagePlus') )
		{
			FaceTexture = RelatedPRI_1.TalkTexture;
			if ( FaceTexture != None )
				FaceTime = Level.TimeSeconds + 3;
		} 
		// Find an empty slot.
		for (i=0; i<6; i++)
		{
			if ( ShortMessageQueue[i].Message == None )
			{
				ShortMessageQueue[i].Message = Message;
				ShortMessageQueue[i].Switch = Switch;
				ShortMessageQueue[i].RelatedPRI = RelatedPRI_1;
				ShortMessageQueue[i].OptionalObject = OptionalObject;
				ShortMessageQueue[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				if ( Message.Default.bComplexString )
					ShortMessageQueue[i].StringMessage = CriticalString;
				else
					ShortMessageQueue[i].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
				return;
			}

		}
		// No empty slots.  Force a message out.
		for (i=0; i<5; i++)
			CopyMessage(ShortMessageQueue[i], ShortMessageQueue[i+1]);

		ShortMessageQueue[5].Message = Message;
		ShortMessageQueue[5].Switch = Switch;
		ShortMessageQueue[5].RelatedPRI = RelatedPRI_1;
		ShortMessageQueue[5].OptionalObject = OptionalObject;
		ShortMessageQueue[5].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		if ( Message.Default.bComplexString )
			ShortMessageQueue[5].StringMessage = CriticalString;
		else
			ShortMessageQueue[5].StringMessage = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		return;
	} 
	else 
	{
		if ( CriticalString == "" )
			CriticalString = Message.Static.GetString(Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
		if ( Message.Default.bIsUnique )
		{
			for (i=0; i<10; i++)
			{
				if (LocalMessages[i].Message != None)
				{
					if ((LocalMessages[i].Message == Message) 
						|| (LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, 24, 640) 
								== Message.Static.GetOffset(Switch, 24, 640)) ) 
					{
						LocalMessages[i].Message = Message;
						LocalMessages[i].Switch = Switch;
						LocalMessages[i].RelatedPRI = RelatedPRI_1;
						LocalMessages[i].OptionalObject = OptionalObject;
						LocalMessages[i].LifeTime = Message.Default.Lifetime;
						LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
						LocalMessages[i].StringMessage = CriticalString;
						LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
						LocalMessages[i].XL = 0;
						return;
					}
				}
			}
		}
		for (i=0; i<10; i++)
		{
			if (LocalMessages[i].Message == None)
			{
				LocalMessages[i].Message = Message;
				LocalMessages[i].Switch = Switch;
				LocalMessages[i].RelatedPRI = RelatedPRI_1;
				LocalMessages[i].OptionalObject = OptionalObject;
				LocalMessages[i].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
				LocalMessages[i].StringMessage = CriticalString;
				LocalMessages[i].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
				LocalMessages[i].LifeTime = Message.Default.Lifetime;
				LocalMessages[i].XL = 0;
				return;
			}
		}

		// No empty slots.  Force a message out.
		for (i=0; i<9; i++)
			CopyMessage(LocalMessages[i],LocalMessages[i+1]);

		LocalMessages[9].Message = Message;
		LocalMessages[9].Switch = Switch;
		LocalMessages[9].RelatedPRI = RelatedPRI_1;
		LocalMessages[9].OptionalObject = OptionalObject;
		LocalMessages[9].EndOfLife = Message.Default.Lifetime + Level.TimeSeconds;
		LocalMessages[9].StringMessage = CriticalString;
		LocalMessages[9].DrawColor = Message.Static.GetColor(Switch, RelatedPRI_1, RelatedPRI_2);				
		LocalMessages[9].LifeTime = Message.Default.Lifetime;
		LocalMessages[9].XL = 0;
		return;
	}
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTimeElapsed( canvas Canvas )
{
local int Hours, Minutes, Seconds;
local float XL, YL;

	Canvas.DrawColor = GreenColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.Font = MyFonts.GetMediumFont( Canvas.ClipX );


	if ( bTimeDown || (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0) )
		{	
		bTimeDown = true;
		if ( PlayerPawn(Owner).GameReplicationInfo.RemainingTime <= 0 )
			{
			Canvas.StrLen("00:00", XL, YL);
			Canvas.SetPos(Canvas.ClipX * 0.5  - 0.5 * XL, YL);
			Canvas.DrawText("00:00", true);
			}
		else
			{
			Minutes = PlayerPawn(Owner).GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerPawn(Owner).GameReplicationInfo.RemainingTime % 60;
			Canvas.StrLen(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
			Canvas.SetPos(Canvas.ClipX * 0.5  - 0.5 * XL, YL);
			Canvas.DrawText(TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
			}
		}
	else
		{
		Seconds = PlayerPawn(Owner).GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.StrLen(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), XL, YL);
		Canvas.SetPos(Canvas.ClipX * 0.5  - 0.5 * XL, YL);
		Canvas.DrawText(TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
}

defaultproperties
{
     VersionMessage="Version"
     PlayerCountString="Ideal Player Load:"
     MapTitleString="in"
     AuthorString="by"
     MapTitleString2="Map:"
     AuthorString2="Author:"
     RankString="Rank:"
     SpreadString="Spread:"
     CrosshairCount=9
     CrossHairs(0)="Botpack.CHair1"
     CrossHairs(1)="Botpack.CHair2"
     CrossHairs(2)="Botpack.CHair3"
     CrossHairs(3)="Botpack.CHair4"
     CrossHairs(4)="Botpack.CHair5"
     CrossHairs(5)="Botpack.CHair6"
     CrossHairs(6)="Botpack.CHair7"
     CrossHairs(7)="Botpack.CHair8"
     CrossHairs(8)="Botpack.CHair9"
     FP1(0)=Texture'Botpack.FacePanel.FacePanel1'
     FP1(1)=Texture'Botpack.FacePanel.FacePanel1b'
     FP1(2)=Texture'Botpack.FacePanel.FacePanel1a'
     FP2(0)=Texture'Botpack.FacePanel.FacePanel2'
     FP2(1)=Texture'Botpack.FacePanel.FacePanel2b'
     FP2(2)=Texture'Botpack.FacePanel.FacePanel2a'
     FP3(0)=Texture'Botpack.FacePanel.FacePanel3'
     FP3(1)=Texture'Botpack.FacePanel.FacePanel3b'
     FP3(2)=Texture'Botpack.FacePanel.FacePanel3a'
     bStartUpMessage=True
     bUseTeamColor=True
     Opacity=15
     HUDScale=1.000000
     StatusScale=1.000000
     WeaponScale=0.800000
     FavoriteHUDColor=(B=16)
     CrosshairColor=(G=16)
     Style=3
     WhiteColor=(R=0,G=0,B=0)
     RedColor=(R=255)
     GreenColor=(G=255)
     CyanColor=(G=255,B=255)
     UnitColor=(R=1,G=1,B=1)
     BlueColor=(B=255)
     GoldColor=(R=255,G=255)
     PurpleColor=(R=255,B=255)
     TurqColor=(G=128,B=255)
     GrayColor=(R=200,G=200,B=200)
     InfoColor=(R=0,G=0,B=0)
     FaceColor=(R=50,G=50,B=50)
     BlackColor=(R=0,G=0,B=0)
     FrameColor=(R=255,G=255)
     IdentifyName="Name:"
     IdentifyHealth="Health:"
     IdentifyCallsign="Callsign:"
     LiveFeed="Live Feed from "
     ScoreTime=-10000000.000000
     ServerInfoClass=Class'Botpack.ServerInfo'
     FontInfoClass="Botpack.FontInfo"
     mMinScale=0.300000
     mMaxScale=14.000000
     bPlayBoom=True
     Skill="MaxHealth"
     Guns="Lawgiver"
}
